/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterCommentNode;

public class FormatterPHPCommentNode
extends FormatterCommentNode {
    private boolean isFirstline;
    private boolean isMultiLine;

    public FormatterPHPCommentNode(IFormatterDocument document, int startOffset, int endOffset, boolean isMultiLine, boolean isFirstline) {
        super(document, startOffset, endOffset);
        this.isMultiLine = isMultiLine;
        this.isFirstline = isFirstline;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean currentCommentState = context.isComment();
        context.setComment(true);
        if (this.getDocument().getBoolean(this.getWrappingKey())) {
            boolean savedWrapping = context.isWrapping();
            context.setWrapping(true);
            this.writeCommentLine(visitor, context, this.getStartOffset(), this.getEndOffset());
            context.setWrapping(savedWrapping);
        } else {
            this.writeCommentLine(visitor, context, this.getStartOffset(), this.getEndOffset());
        }
        context.setComment(currentCommentState);
    }

    protected void writeCommentLine(IFormatterWriter visitor, IFormatterContext context, int startOffset, int endOffset) {
        if (!visitor.endsWithNewLine() && !this.isFirstline && this.isMultiLine) {
            visitor.writeLineBreak(context);
        }
        if (!this.isMultiLine) {
            visitor.write(context, startOffset, endOffset);
        } else {
            if (!this.isFirstline) {
                visitor.ensureLineStarted(context);
                visitor.writeText(context, " ", false);
            }
            visitor.write(context, startOffset, endOffset);
        }
    }

    public String getWrappingKey() {
        return "php.formatter.wrap.comments";
    }
}

